if not turtle then
	printError("Requires a Turtle")
	return
end

junk = require("junk")

local protect = {
	"minecraft:diamond_ore",
	"minecraft:deepslate_diamond_ore",
	"minecraft:budding_amethyst",
}


local collected = 0

local function collect()
	collected = collected + 1
	if math.fmod(collected, 25) == 0 then
		print("Mined " .. collected .. " items.")
	end
	if math.fmod(collected, 100) == 0 then
		print("Dropping and consolidating")
		junk.dropjunk()
		junk.consolidate()
	end
end

local function isProtected(name)
	for i = 1, #protect do
		if name == protect[i] then
			return true
		end
	end
	return false
end

local function checkProtect(func)
	local has_block, data = func()
	while has_block and isProtected(data["name"]) do
		sleep(0.1)
		has_block, data = func()
	end
	return has_block
end

local function tryDig()
	while checkProtect(turtle.inspect) do
		if turtle.dig() then
			collect()
			sleep(0.5)
		else
			return false
		end
	end
	return true
end

local function tryDigUp()
	while checkProtect(turtle.inspectUp) do
		if turtle.digUp() then
			collect()
			sleep(0.5)
		else
			return false
		end
	end
	return true
end

local function tryDigDown()
	while checkProtect(turtle.inspectDown) do
		if turtle.digDown() then
			collect()
			sleep(0.5)
		else
			return false
		end
	end
	return true
end


local function refuel()
	local fuelLevel = turtle.getFuelLevel()
	if fuelLevel == "unlimited" or fuelLevel > 0 then
		return
	end

	local function tryRefuel()
		for n = 1, 16 do
			if turtle.getItemCount(n) > 0 then
				turtle.select(n)
				if turtle.refuel(1) then
					turtle.select(1)
					return true
				end
			end
		end
		turtle.select(1)
		return false
	end

	if not tryRefuel() then
		print("Add more fuel to continue.")
		while not tryRefuel() do
			os.pullEvent("turtle_inventory")
		end
		print("Resuming Tunnel.")
	end
end

local function tryUp()
	refuel()
	while not turtle.up() do
		if turtle.detectUp() then
			if not tryDigUp() then
				return false
			end
		elseif turtle.attackUp() then
			collect()
		else
			sleep(0.5)
		end
	end
	return true
end

local function tryDown()
	refuel()
	while not turtle.down() do
		if turtle.detectDown() then
			if not tryDigDown() then
				return false
			end
		elseif turtle.attackDown() then
			collect()
		else
			sleep(0.5)
		end
	end
	return true
end

local function tryForward()
	refuel()
	while not turtle.forward() do
		if turtle.detect() then
			if not tryDig() then
				return false
			end
		elseif turtle.attack() then
			collect()
		else
			sleep(0.5)
		end
	end
	return true
end


local function doTunnel(length, action)
	print("Tunnelling...")

	for n = 1, length do
		action()

		if n < length then
			tryDig()
			if not tryForward() then
				print("Aborting Tunnel.")
				break
			end
		else
			print("Tunnel complete.")
		end
	end

	print("Tunnel complete.")
	print("Mined " .. collected .. " items total.")
end

return {
	collect = collect,
	collected = collected,
	tryDig = tryDig,
	tryDigUp = tryDigUp,
	tryDigDown = tryDigDown,
	tryUp = tryUp,
	tryDown = tryDown,
	tryForward = tryForward,
	doTunnel = doTunnel,
}
