local inv = peripheral.find("inventoryManager")
local chat = peripheral.find("chatBox")

local username = "Infinidoge"
local prefix = "Storage"

local expansions = {
	b = "botania",
	c = "create",
	cc = "computercraft",
}

function reply(message)
	chat.sendMessageToPlayer(message, username, prefix)
end

function notify(player, log, count, item)
	reply(player .. " " .. count .. " " .. item["name"])
	print(log .. " " .. count .. " " .. item["name"])
end

function handleSend(item)
	local count = inv.removeItemFromPlayer("left", item)
	notify("Received", "Receiving", count, item)
end

function handleReceive(item)
	local count = inv.addItemToPlayer("left", item)
	notify("Sent", "Sending", count, item)
end

function parseItem(message --[[string]], defaultCount)
	local mult, base, item = message:match("(%d+)[x*](%d+) (.+)")
	local count, item = message:match("(%d+) (.+)")

	if mult and base then
		mult = tonumber(mult)
		base = tonumber(base)
		count = mult * base
	elseif count then
		count = tonumber(count)
	else
		count = defaultCount
		item = message
	end

	local namespace, id = item:match("(.+):(.+)")

	if namespace and id then
		namespace = expansions[namespace] or namespace
		item = id
	else
		namespace = "minecraft"
	end

	item = namespace .. ":" .. item

	output = { name = item }
	if count then
		output["count"] = count
	end

	return output
end

--function handleList()
--end

function parseCommand(message)
	--local list = message:match("li?s?t?")
	local send = message:match("se?n?d? (.+)")
	local receive = message:match("re?c?e?i?v?e? (.+)")

	if send then
		handleSend(parseItem(send, 99999999))
	elseif receive then
		handleReceive(parseItem(receive, 64))
	end
end

while true do
	local _, _, message, _, isHidden = os.pullEvent("chat")

	parseCommand(message)
end
