local junk = {
	"minecraft:cobblestone",
	"minecraft:dirt",
	"minecraft:cobbled_deepslate",
	"minecraft:granite",
	"minecraft:gravel",
	"minecraft:flint",
	"minecraft:smooth_bassalt",
	"minecraft:glow_berries",
	"minecraft:magma_block",
	"yungscavebiomes:layered_ancient_sandstone",
	"yungscavebiomes:brittle_ancient_sandstone",
	"yungscavebiomes:ancient_sandstone",
	"yungscavebiomes:ancient_sand",
}

local function dropjunk()
	turtle.turnLeft()
	turtle.turnLeft()

	for i = 1, 16 do
		turtle.select(i)
		local item = turtle.getItemDetail()
		for j = 1, #junk do
			if item and item["name"] == junk[j] then
				turtle.drop()
			end
		end
	end

	turtle.select(1)

	turtle.turnLeft()
	turtle.turnLeft()
end

local function consolidate()
	for from = 16, 1, -1 do
		local fromItem = turtle.getItemDetail(from)
		if fromItem then
			turtle.select(from)
			for to = 1, from do
				local toItem = turtle.getItemDetail(to)
				if toItem and fromItem["name"] == toItem["name"] then
					turtle.transferTo(to)
					break
				elseif not toItem then
					turtle.transferTo(to)
					break
				end
			end
		end
	end

	turtle.select(1)
end

return { junk = junk, dropjunk = dropjunk, consolidate = consolidate }
