local ecc = require("ecc")
local exception = require "cc.internal.exception"

rednet.open("left")

local publicKeyFile = io.open("publickey")
assert(publicKeyFile)
local publicKey = publicKeyFile:read("a")
publicKeyFile:close()

publicKey = { publicKey:byte(1, -1) }

local command_types = {
	lua = function(command)
		load(command.value)()
	end,
	run = function(command)
		shell.run(command.value)
	end,
	download = function(command)
		shell.run("wget " .. command.url)
	end
}

while true do
	local _, message = rednet.receive("inx_command")

	if message and ecc.verify(publicKey, message.command, message.signature) then
		local command = textutils.unserialize(message.command)

		assert(command ~= nil)
		assert(command.type ~= nil)

		local results = table.pack(exception.try(command_types[command.type], command))
	else
		print("failed to verify message")
	end
end
