ecc = require("ecc")

rednet.open("back")

local privateKeyFile = io.open("privatekey")
assert(privateKeyFile)
local privateKey = privateKeyFile:read("a")
privateKeyFile:close()

privateKey = { privateKey:byte(1, -1) }

function sendCommand(cmdtype, command)
	command.type = cmdtype

	serialized = textutils.serialize(command, { compact = true })

	packet = {
		command = serialized,
		signature = ecc.sign(privateKey, serialized)
	}

	rednet.broadcast(packet, "inx_command")
end

function modeLua()
	local history = {}
	while true do
		write("lua> ")
		command = read(nil, history)
		if command == "exit" or command == "exit()" then
			break
		elseif command:match("%s") and history[#history] ~= command then
			table.insert(history, command)
		else
			sendCommand("lua", { value = command })
		end
	end
end

print("=== Command ===")
while true do
	write("> ")
	local input = read()
	local command = input:match("run (.+)")
	if input == "lua" then
		modeLua()
	elseif input == "exit" then
		break
	elseif command then
		sendCommand("run", { value = command })
	else
		print("invalid command")
	end
end
