tunnel = require("tunnellib")

local tArgs = { ... }
if #tArgs ~= 1 then
	local programName = arg[0] or fs.getName(shell.getRunningProgram())
	print("Usage: " .. programName .. " <length>")
	return
end

-- Mine in a quarry pattern until we hit something we can't dig
local length = tonumber(tArgs[1])
if length < 1 then
	print("Tunnel length must be positive")
	return
end

local function dig2x3()
	tunnel.tryDigUp()
	turtle.turnLeft()
	tunnel.tryDig()
	tunnel.tryUp()
	tunnel.tryDig()
	turtle.turnRight()
	turtle.turnRight()
	tunnel.tryDig()
	tunnel.tryDown()
	tunnel.tryDig()
	turtle.turnLeft()
end

tunnel.doTunnel(length, dig2x3)
