{
  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixpkgs-unstable";
    flake-utils.url = "github:numtide/flake-utils";

    apkrev = { url = "github:nyancrimew/apkrev"; flake = false; };
  };

  outputs = { self, nixpkgs, flake-utils, ... }@inputs:
    flake-utils.lib.eachDefaultSystem (system:
      let
        pkgs = nixpkgs.legacyPackages.${system};

        inherit (pkgs) lib;
      in
      rec {
        packages.apkrev = pkgs.stdenvNoCC.mkDerivation {
          name = "apkrev";
          src = inputs.apkrev;
          installPhase = ''
            install -m755 -D $src/apkrev $out/bin/apkrev
            patchShebangs
          '';
        };

        devShells.default = pkgs.mkShell {
          name = "dev deps";
          buildInputs = with pkgs; [
            jadx
            packages.apkrev
          ];
        };
      }
    );
}
