/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.config.ConfigKey;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public abstract class AbstractConfiguration {
    private static final TypeAdapter<JsonObject> ADAPTER = new Gson().getAdapter(JsonObject.class);
    private final File CFG_FILE;
    public JsonObject SAVE_VALUES = new JsonObject();

    protected AbstractConfiguration(String directory, String cfgName) {
        Path saveDir = FabricLoader.getInstance().getConfigDir().resolve(directory);
        if (AbstractConfiguration.supportsSaving() && !Files.isDirectory(saveDir, new LinkOption[0])) {
            try {
                Files.createDirectory(saveDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                WildfireGender.LOGGER.error("Failed to create config directory", (Throwable)e);
            }
        }
        this.CFG_FILE = saveDir.resolve(cfgName + ".json").toFile();
    }

    public static boolean supportsSaving() {
        return FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER;
    }

    public <TYPE> void set(ConfigKey<TYPE> key, TYPE value) {
        key.save(this.SAVE_VALUES, value);
    }

    public <TYPE> TYPE get(ConfigKey<TYPE> key) {
        return key.read(this.SAVE_VALUES);
    }

    public <TYPE> void setDefault(ConfigKey<TYPE> key) {
        if (!this.SAVE_VALUES.has(key.key)) {
            this.set(key, key.defaultValue);
        }
    }

    public void removeParameter(ConfigKey<?> key) {
        this.removeParameter(key.key);
    }

    public void removeParameter(String key) {
        this.SAVE_VALUES.remove(key);
    }

    public void save() {
        if (!AbstractConfiguration.supportsSaving()) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.CFG_FILE);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            jsonWriter.setIndent("\t");
            ADAPTER.write(jsonWriter, (Object)this.SAVE_VALUES);
        }
        catch (IOException e) {
            WildfireGender.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public void load() {
        if (!AbstractConfiguration.supportsSaving() || !this.CFG_FILE.exists()) {
            return;
        }
        try (FileReader configurationFile = new FileReader(this.CFG_FILE);){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)configurationFile, JsonObject.class);
            for (Map.Entry entry : obj.entrySet()) {
                this.SAVE_VALUES.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        catch (IOException e) {
            WildfireGender.LOGGER.error("Failed to load config file", (Throwable)e);
        }
    }
}

