/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.wildfire.api.IGenderArmor;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.physics.BreastPhysics;
import com.wildfire.render.BreastSide;
import com.wildfire.render.WildfireModelRenderer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1292;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class GenderLayer<T extends class_1309, M extends class_572<T>>
extends class_3887<T, M> {
    private WildfireModelRenderer.BreastModelBox lBreast;
    private WildfireModelRenderer.BreastModelBox rBreast;
    private final class_3883<T, M> context;
    private static final WildfireModelRenderer.OverlayModelBox lBreastWear = new WildfireModelRenderer.OverlayModelBox(true, 64, 64, 17, 34, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private static final WildfireModelRenderer.OverlayModelBox rBreastWear = new WildfireModelRenderer.OverlayModelBox(false, 64, 64, 21, 34, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private float preBreastSize;
    private float preBreastOffsetZ;
    private Breasts breasts;
    protected class_1799 armorStack;
    protected IGenderArmor genderArmor;
    protected boolean isChestplateOccupied;
    protected boolean bounceEnabled;
    protected boolean breathingAnimation;
    protected float breastOffsetX;
    protected float breastOffsetY;
    protected float breastOffsetZ;
    protected float lPhysPositionY;
    protected float lPhysPositionX;
    protected float rPhysPositionY;
    protected float rPhysPositionX;
    protected float lPhysBounceRotation;
    protected float rPhysBounceRotation;
    protected float breastSize;
    protected float zOffset;
    protected float outwardAngle;

    public GenderLayer(class_3883<T, M> render) {
        super(render);
        this.context = render;
        this.lBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 4, 0.0f, false);
        this.rBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 4, 0.0f, false);
    }

    @Nullable
    private class_1921 getRenderLayer(T entity) {
        class_3883<T, M> class_38832 = this.context;
        if (class_38832 instanceof class_922) {
            class_922 renderer = (class_922)class_38832;
            class_310 client = class_310.method_1551();
            boolean bodyVisible = !entity.method_5767();
            boolean translucent = !bodyVisible && client.field_1724 != null && !entity.method_5756((class_1657)client.field_1724);
            boolean glowing = client.method_27022(entity);
            return renderer.method_24302(entity, bodyVisible, translucent, glowing);
        }
        throw new IllegalStateException("context renderer is not a LivingEntityRenderer");
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, @NotNull T ent, float limbAngle, float limbDistance, float partialTicks, float animationProgress, float headYaw, float headPitch) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        EntityConfig entityConfig = EntityConfig.getEntity(ent);
        if (entityConfig == null) {
            return;
        }
        try {
            if (!this.setupRender(ent, entityConfig, partialTicks)) {
                return;
            }
            int overlay = class_922.method_23622(ent, (float)0.0f);
            this.renderSides(ent, (class_572)this.method_17165(), matrixStack, side -> this.renderBreast(ent, matrixStack, vertexConsumerProvider, light, overlay, (BreastSide)((Object)side)));
        }
        catch (Exception e) {
            WildfireGender.LOGGER.error("Failed to render breast layer", (Throwable)e);
        }
    }

    protected boolean setupRender(T entity, EntityConfig entityConfig, float partialTicks) {
        this.armorStack = entity.method_6118(class_1304.field_6174);
        this.genderArmor = WildfireHelper.getArmorConfig(this.armorStack);
        boolean bl = this.isChestplateOccupied = this.genderArmor.coversBreasts() && !entityConfig.getArmorPhysicsOverride();
        if (this.genderArmor.alwaysHidesBreasts() || !entityConfig.showBreastsInArmor() && this.isChestplateOccupied) {
            return false;
        }
        class_1921 type = this.getRenderLayer(entity);
        if (type == null && !this.isChestplateOccupied) {
            return false;
        }
        this.breasts = entityConfig.getBreasts();
        this.breastOffsetX = (float)Math.round((float)Math.round(this.breasts.getXOffset() * 100.0f) / 100.0f * 10.0f) / 10.0f;
        this.breastOffsetY = (float)(-Math.round((float)Math.round(this.breasts.getYOffset() * 100.0f) / 100.0f * 10.0f)) / 10.0f;
        this.breastOffsetZ = (float)(-Math.round((float)Math.round(this.breasts.getZOffset() * 100.0f) / 100.0f * 10.0f)) / 10.0f;
        BreastPhysics leftBreastPhysics = entityConfig.getLeftBreastPhysics();
        float bSize = leftBreastPhysics.getBreastSize(partialTicks);
        this.outwardAngle = (float)Math.round(this.breasts.getCleavage() * 100.0f) / 100.0f * 100.0f;
        this.outwardAngle = Math.min(this.outwardAngle, 10.0f);
        this.resizeBox(bSize);
        this.lPhysPositionY = class_3532.method_16439((float)partialTicks, (float)leftBreastPhysics.getPrePositionY(), (float)leftBreastPhysics.getPositionY());
        this.lPhysPositionX = class_3532.method_16439((float)partialTicks, (float)leftBreastPhysics.getPrePositionX(), (float)leftBreastPhysics.getPositionX());
        this.lPhysBounceRotation = class_3532.method_16439((float)partialTicks, (float)leftBreastPhysics.getPreBounceRotation(), (float)leftBreastPhysics.getBounceRotation());
        if (this.breasts.isUniboob()) {
            this.rPhysPositionY = this.lPhysPositionY;
            this.rPhysPositionX = this.lPhysPositionX;
            this.rPhysBounceRotation = this.lPhysBounceRotation;
        } else {
            BreastPhysics rightBreastPhysics = entityConfig.getRightBreastPhysics();
            this.rPhysPositionY = class_3532.method_16439((float)partialTicks, (float)rightBreastPhysics.getPrePositionY(), (float)rightBreastPhysics.getPositionY());
            this.rPhysPositionX = class_3532.method_16439((float)partialTicks, (float)rightBreastPhysics.getPrePositionX(), (float)rightBreastPhysics.getPositionX());
            this.rPhysBounceRotation = class_3532.method_16439((float)partialTicks, (float)rightBreastPhysics.getPreBounceRotation(), (float)rightBreastPhysics.getBounceRotation());
        }
        this.breastSize = bSize * 1.5f;
        if (this.breastSize > 0.7f) {
            this.breastSize = 0.7f;
        }
        if (bSize > 0.7f) {
            this.breastSize = bSize;
        }
        if (this.breastSize < 0.02f) {
            return false;
        }
        this.zOffset = 0.0625f - bSize * 0.0625f;
        this.breastSize = bSize + 0.5f * Math.abs(bSize - 0.7f) * 2.0f;
        float resistance = class_3532.method_15363((float)this.genderArmor.physicsResistance(), (float)0.0f, (float)1.0f);
        this.breathingAnimation = !(!entityConfig.getArmorPhysicsOverride() && !(resistance <= 0.5f) || entity.method_5869() && !class_1292.method_5574(entity) && !entity.method_37908().method_8320(new class_2338(entity.method_31477(), entity.method_31478(), entity.method_31479())).method_27852(class_2246.field_10422));
        this.bounceEnabled = entityConfig.hasBreastPhysics() && (!this.isChestplateOccupied || resistance < 1.0f);
        return true;
    }

    protected void resizeBox(float breastSize) {
        float reducer = -1.0f;
        if (breastSize < 0.84f) {
            reducer += 1.0f;
        }
        if (breastSize < 0.72f) {
            reducer += 1.0f;
        }
        if (this.preBreastSize != breastSize || this.preBreastOffsetZ != this.breastOffsetZ) {
            this.lBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, (int)(4.0f - this.breastOffsetZ - reducer), 0.0f, false);
            this.rBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, (int)(4.0f - this.breastOffsetZ - reducer), 0.0f, false);
            this.preBreastSize = breastSize;
            this.preBreastOffsetZ = this.breastOffsetZ;
        }
    }

    protected void setupTransformations(T entity, M model, class_4587 matrixStack, BreastSide side) {
        if (entity.method_6109()) {
            float f1 = 1.0f / ((class_572)model).field_20919;
            matrixStack.method_22905(f1, f1, f1);
            matrixStack.method_46416(0.0f, ((class_572)model).field_20920 / 16.0f, 0.0f);
        }
        class_630 body = ((class_572)model).field_3391;
        matrixStack.method_46416(body.field_3657 * 0.0625f, body.field_3656 * 0.0625f, body.field_3655 * 0.0625f);
        if (body.field_3674 != 0.0f) {
            matrixStack.method_22907(new Quaternionf().rotationXYZ(0.0f, 0.0f, body.field_3674));
        }
        if (body.field_3675 != 0.0f) {
            matrixStack.method_22907(new Quaternionf().rotationXYZ(0.0f, body.field_3675, 0.0f));
        }
        if (body.field_3654 != 0.0f) {
            matrixStack.method_22907(new Quaternionf().rotationXYZ(body.field_3654, 0.0f, 0.0f));
        }
        if (this.bounceEnabled) {
            matrixStack.method_46416((side.isLeft ? this.lPhysPositionX : this.rPhysPositionX) / 32.0f, 0.0f, 0.0f);
            matrixStack.method_46416(0.0f, (side.isLeft ? this.lPhysPositionY : this.rPhysPositionY) / 32.0f, 0.0f);
        }
        matrixStack.method_46416((side.isLeft ? this.breastOffsetX : -this.breastOffsetX) * 0.0625f, 0.05625f + this.breastOffsetY * 0.0625f, this.zOffset - 0.125f + this.breastOffsetZ * 0.0625f);
        if (!this.breasts.isUniboob()) {
            matrixStack.method_46416(-0.125f * (float)(side.isLeft ? 1 : -1), 0.0f, 0.0f);
        }
        if (this.bounceEnabled) {
            matrixStack.method_22907(new Quaternionf().rotationXYZ(0.0f, (float)((double)(side.isLeft ? this.lPhysBounceRotation : this.rPhysBounceRotation) * (Math.PI / 180)), 0.0f));
        }
        if (!this.breasts.isUniboob()) {
            matrixStack.method_46416(0.125f * (float)(side.isLeft ? 1 : -1), 0.0f, 0.0f);
        }
        float rotationMultiplier = 0.0f;
        if (this.bounceEnabled) {
            matrixStack.method_46416(0.0f, -0.035f * this.breastSize, 0.0f);
            rotationMultiplier = -(side.isLeft ? this.lPhysPositionY : this.rPhysPositionY) / 12.0f;
        }
        float totalRotation = this.breastSize + rotationMultiplier;
        if (!this.bounceEnabled) {
            totalRotation = this.breastSize;
        }
        if (totalRotation > this.breastSize + 0.2f) {
            totalRotation = this.breastSize + 0.2f;
        }
        totalRotation = Math.min(totalRotation, 1.0f);
        if (this.isChestplateOccupied) {
            matrixStack.method_46416(0.0f, 0.0f, 0.01f);
        }
        matrixStack.method_22907(new Quaternionf().rotationXYZ(0.0f, (float)((double)(side.isLeft ? this.outwardAngle : -this.outwardAngle) * (Math.PI / 180)), 0.0f));
        matrixStack.method_22907(new Quaternionf().rotationXYZ((float)((double)(-35.0f * totalRotation) * (Math.PI / 180)), 0.0f, 0.0f));
        if (this.breathingAnimation) {
            float f5 = -class_3532.method_15362((float)((float)((class_1309)entity).field_6012 * 0.09f)) * 0.45f + 0.45f;
            matrixStack.method_22907(new Quaternionf().rotationXYZ((float)((double)f5 * (Math.PI / 180)), 0.0f, 0.0f));
        }
        matrixStack.method_22905(0.9995f, 1.0f, 1.0f);
    }

    private void renderBreast(T entity, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay, BreastSide side) {
        class_742 player;
        class_1921 breastRenderType = this.getRenderLayer(entity);
        if (breastRenderType == null) {
            return;
        }
        int alpha = entity.method_5767() ? class_5253.method_59553((float)0.15f) : 255;
        int color = class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(breastRenderType);
        GenderLayer.renderBox(side.isLeft ? this.lBreast : this.rBreast, matrixStack, vertexConsumer, light, overlay, color);
        if (entity instanceof class_742 && (player = (class_742)entity).method_7348(class_1664.field_7564)) {
            matrixStack.method_46416(0.0f, 0.0f, -0.015f);
            matrixStack.method_22905(1.05f, 1.05f, 1.05f);
            GenderLayer.renderBox(side.isLeft ? lBreastWear : rBreastWear, matrixStack, vertexConsumer, light, overlay, color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSides(T entity, M model, class_4587 matrixStack, Consumer<BreastSide> renderer) {
        matrixStack.method_22903();
        try {
            this.setupTransformations(entity, model, matrixStack, BreastSide.LEFT);
            renderer.accept(BreastSide.LEFT);
        }
        finally {
            matrixStack.method_22909();
        }
        matrixStack.method_22903();
        try {
            this.setupTransformations(entity, model, matrixStack, BreastSide.RIGHT);
            renderer.accept(BreastSide.RIGHT);
        }
        finally {
            matrixStack.method_22909();
        }
    }

    protected static void renderBox(WildfireModelRenderer.ModelBox model, class_4587 matrixStack, class_4588 vertexConsumer, int light, int overlay, int color) {
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        Matrix3f matrix3f = matrixStack.method_23760().method_23762();
        for (WildfireModelRenderer.TexturedQuad quad : model.quads) {
            Vector3f vector3f = new Vector3f(quad.normal.x, quad.normal.y, quad.normal.z).mul((Matrix3fc)matrix3f);
            float normalX = vector3f.x;
            float normalY = vector3f.y;
            float normalZ = vector3f.z;
            for (WildfireModelRenderer.PositionTextureVertex vertex : quad.vertexPositions) {
                float j = vertex.x() / 16.0f;
                float k = vertex.y() / 16.0f;
                float l = vertex.z() / 16.0f;
                Vector4f vector4f = new Vector4f(j, k, l, 1.0f).mul((Matrix4fc)matrix4f);
                vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), color, vertex.u(), vertex.v(), overlay, light, normalX, normalY, normalZ);
            }
        }
    }
}

