/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireGenderClient;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.ServerboundSyncPacket;
import com.wildfire.main.networking.WildfireSync;
import com.wildfire.render.GenderArmorLayer;
import com.wildfire.render.GenderLayer;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_437;
import net.minecraft.class_5617;
import net.minecraft.class_634;
import net.minecraft.class_742;
import net.minecraft.class_877;
import net.minecraft.class_922;
import net.minecraft.server.MinecraftServer;

public final class WildfireEventHandler {
    private static final class_304 CONFIG_KEYBIND;
    private static int timer;

    private WildfireEventHandler() {
        throw new UnsupportedOperationException();
    }

    public static void registerCommonEvents() {
        EntityTrackingEvents.START_TRACKING.register(WildfireEventHandler::onBeginTracking);
        ServerPlayConnectionEvents.DISCONNECT.register(WildfireEventHandler::playerDisconnected);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientEvents() {
        ClientEntityEvents.ENTITY_LOAD.register(WildfireEventHandler::onEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(WildfireEventHandler::onEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(WildfireEventHandler::onClientTick);
        ClientPlayConnectionEvents.DISCONNECT.register(WildfireEventHandler::clientDisconnect);
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register(WildfireEventHandler::registerRenderLayers);
    }

    @Environment(value=EnvType.CLIENT)
    private static void registerRenderLayers(class_1299<? extends class_1309> entityType, class_922<?, ?> entityRenderer, LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper registrationHelper, class_5617.class_5618 context) {
        if (entityRenderer instanceof class_1007) {
            class_1007 playerRenderer = (class_1007)entityRenderer;
            registrationHelper.register(new GenderLayer(playerRenderer));
            registrationHelper.register(new GenderArmorLayer(playerRenderer, context.method_48481()));
        } else if (entityRenderer instanceof class_877) {
            class_877 armorStandRenderer = (class_877)entityRenderer;
            registrationHelper.register(new GenderArmorLayer(armorStandRenderer, context.method_48481()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void onEntityLoad(class_1297 entity, class_1937 world) {
        if (!world.method_8608() || class_310.method_1551().field_1724 == null) {
            return;
        }
        if (entity instanceof class_742) {
            class_742 plr = (class_742)entity;
            UUID uuid = plr.method_5667();
            boolean isClientPlayer = uuid.equals(class_310.method_1551().field_1724.method_5667());
            WildfireGenderClient.loadPlayerIfMissing(uuid, isClientPlayer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void onEntityUnload(class_1297 entity, class_1937 world) {
        EntityConfig.ENTITY_CACHE.remove(entity.method_5667());
    }

    @Environment(value=EnvType.CLIENT)
    private static void onClientTick(class_310 client) {
        PlayerConfig aPlr;
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (ServerboundSyncPacket.canSend() && timer++ % 5 == 0 && (aPlr = WildfireGender.getPlayerById(client.field_1724.method_5667())) != null) {
            WildfireSync.sendToServer(aPlr);
        }
        if (CONFIG_KEYBIND.method_1436() && client.field_1755 == null) {
            client.method_1507((class_437)new WardrobeBrowserScreen(null, client.field_1724.method_5667()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void clientDisconnect(class_634 networkHandler, class_310 client) {
        WildfireGender.PLAYER_CACHE.clear();
        EntityConfig.ENTITY_CACHE.clear();
    }

    private static void playerDisconnected(class_3244 handler, MinecraftServer server) {
        WildfireGender.PLAYER_CACHE.remove(handler.method_32311().method_5667());
    }

    private static void onBeginTracking(class_1297 tracked, class_3222 syncTo) {
        if (tracked instanceof class_1657) {
            class_1657 toSync = (class_1657)tracked;
            PlayerConfig genderToSync = WildfireGender.getPlayerById(toSync.method_5667());
            if (genderToSync == null) {
                return;
            }
            WildfireSync.sendToClient(syncTo, genderToSync);
        }
    }

    static {
        timer = 0;
        CONFIG_KEYBIND = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? (class_304)class_156.method_656(() -> {
            class_304 keybind = new class_304("key.wildfire_gender.gender_menu", 71, "category.wildfire_gender.generic");
            KeyBindingHelper.registerKeyBinding((class_304)keybind);
            return keybind;
        }) : null;
    }
}

