# The Owl House and the Echo Chambers of Emperor Belos
<!-- vim: set sw=2 ts=2 wrap linebreak: -->

## Introduction to The Owl House

The Owl House is a show created by Dana Terrace, produced by Disney and first airing in 2020.
Primarily taking place on the Boiling Isles in the Demon Realm, a dimension separate from our Human Realm, the show centers on Luz Noceda, a human who finds herself on the Boiling Isles after traveling through a portal owned by Eda Clawthorne, commonly known as 'Eda the Owl Lady'.
Throughout the show we are introduced to a large supporting cast of characters, however we will mostly be focusing on the primary antagonist: Emperor Belos.
This video will contain spoilers for plot points later on in the story.

## Introduction to Belos

Emperor Belos is the ruler of the Boiling Isles, head of the Emperor's Coven, and main villain of the series.
His stated goal was to save the Boiling Isles from wild magic, and the wild witches who practiced it.
He claims that he can speak with the Titan, the corpse of whom makes up the Boiling Isles and is a god figure in the Isles.
<!-- Insert clip of Belos claiming that it is the Titan's will to eliminate wild magic and wild witches -->
Later on in the series, Belos is revealed to have been Philip Whittebane, a human witch hunter who came to the Boiling Isles centuries ago.
Instead of trying to eliminate wild magic, his actual goal was instead to eliminate magic altogether, killing all witches and demons in the process.
This culminates in the Day of Unity, which he claims will unite the Demon Realm and the Human Realm to bring paradise to the worthy, but instead is a draining spell he uses to try and kill the Demon Realms' inhabitants.
Belos is notable as an antagonist for how his history was shaped by an epistemic bubble, and how he weaponizes his echo chamber to maintain his image.

## Philosophical Concepts

Before we get into that, however, we need to talk about epistemic networks, epistemic bubbles, and echo chambers.

### Epistemic Networks

Epistemic networks are a way of representing how people spread information to each other.
Each point is a person, and each line between them represents sharing information or testimony.
The knowledge you have is largely a product of the epistemic network you are a part of, from your parents, to your friends, to your teachers.
Epistemic networks also affect whether or not you'll accept certain evidence, based on whether your networks trust those sources of evidence.

### Epistemic Bubbles

Epistemic bubbles are a form of epistemic network that omits certain relevant voices, either purposefully or inadvertently, but not intentionally directed by a person or group.
An epistemic bubble could lead you to ignoring or dismissing people you consider outsiders, or dismissing things that may seem crazy based on what you've heard from within your epistemic network. 

### Echo Chambers

Echo chambers are similar to epistemic bubbles, however their exclusion of relevant voices is intentional, and generally a lot more broad.
Echo chambers frequently appear in cults, both of which alienate their members from outside information in order to reinforce their commitment to the in-group, and only following information produced by the in-group.
It leads to only inside sources being considered trustworthy.

## Philosophical Underpinnings

Belos very intentionally manipulates people through deception and controlling the information they receive.
He claims that he is the only person who can speak with the titan, and he uses that claim to form an epistemic network centered around himself.
<!-- Insert clips of Belos claiming things about the titan -->
Over time, he expands this network to cover the entire Boiling Isles, leading to many to accept his word uncritically, despite it not having any evidence to back it up.
The Emperor's Coven, which acts as his personal army and task force, serve as an echo chamber.
They repeat Belos' lies, and induct members of the public into their covens, restricting their magic, and accepting the best they can find to join their ranks.
<!-- Insert clip of Belos/The Emperor's Coven... doing that -->
His identity as a witch hunter has historical relevance, because he himself was subject to an epistemic bubble, which led to him becoming a witch hunter.
In Connecticut during the mid to late 17th century, the first large-scale witch trials were conducted in the United States.
In this environment a boy growing up would hear from everybody in their epistemic network about the dangers and evils of witches, and might aspire to root out their evil should he discover it.
This is an epistemic bubble and not an echo chamber because the people in the epistemic network were not actively discrediting or suppressing information to foster a hatred of witches.
Rather, their collective belief was self-reinforcing, as they got information from those around them that furthered their belief.
In contrast to Belos, Caleb (Belos's brother) got to know a witch from the Boiling Isles and fell in love.
He added a new node to his epistemic network and popped the epistemic bubble, learning more about an outside perspective those who surrounded him ignored.
Belos, on the other hand, fell victim to the bubble, killing his brother for his betrayal of cohorting with a witch.

## Aside

These origins and how they are culturally and thematically relevant to the show overall (and Belos as a villain specifically) are discussed more in depth in a character study video essay by skulltrot on YouTube, linked below.
This video essay is what lead me to learning more about Belos' origins.
The video also goes into the historical background that serves as the foundation of Belos' character.

## Specific Examples

# Outro

If you haven't already watched The Owl House, I very much recommend it.
It is one of the best shows to exist, and a stellar work of modern writing and animation.
Featuring amazing queer and neurodivergent representation, neuanced and well-developed characters, a fascinating world and magic system, and more, it proudly sits among my favorite media of all time.
Thank you for watching, and as they say in the show,

<!-- Insert clip of a character from The Owl House saying "Byyyeeeeee!" -->

# Sources

The Owl House (2020)
Specifically relevant episodes:
- S1E19: Young Blood, Old Souls. Lilith (Eda Clawthorne's sister, former head of the Emperor's Coven) breaks out of the echo chamber after Belos breaks his promise. Also shows Belos using the situation as a propaganda opportunity to discredit what Eda has to say.
- S2E16: Hollow Mind. Shows flashbacks to Belos intentionally manipulating people to further his aims, including Hunter (his 'nephew' and second head of the Emperor's Coven). This breaks Hunter out of the echo chamber.
- S3E01: Thanks to Them. Gives context to Belos and Caleb's backstory

Epistemic Bubbles and Echo Chambers: April 10th Lecture Slides
- Epistemic Networks: Slides 4-8, with specific relevance to the example on slide 6
- Epistemic Bubbles: Slides 11-12, 20, 22
- Echo Chambers: Slides 25-29

Belos' Fatal Flaw | A Character Study, by skulltrot on YouTube, https://www.youtube.com/watch?v=CpiI2J3F0PQ
