/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.entitydata;

import com.google.gson.JsonObject;
import com.wildfire.main.Gender;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.config.ConfigKey;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.entitydata.EntityConfig;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class PlayerConfig
extends EntityConfig {
    public boolean needsSync;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    private final Configuration cfg;
    private boolean hurtSounds = (Boolean)Configuration.HURT_SOUNDS.getDefault();
    private boolean armorPhysOverride = (Boolean)Configuration.ARMOR_PHYSICS_OVERRIDE.getDefault();

    public PlayerConfig(UUID uuid) {
        this(uuid, (Gender)((Object)Configuration.GENDER.getDefault()));
    }

    public PlayerConfig(UUID uuid, Gender gender) {
        super(uuid);
        this.gender = gender;
        this.cfg = new Configuration("WildfireGender", this.uuid.toString());
        this.cfg.set(Configuration.USERNAME, this.uuid);
        this.cfg.setDefault(Configuration.GENDER);
        this.cfg.setDefault(Configuration.BUST_SIZE);
        this.cfg.setDefault(Configuration.HURT_SOUNDS);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_X);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_Y);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_Z);
        this.cfg.setDefault(Configuration.BREASTS_UNIBOOB);
        this.cfg.setDefault(Configuration.BREASTS_CLEAVAGE);
        this.cfg.setDefault(Configuration.BREAST_PHYSICS);
        this.cfg.setDefault(Configuration.ARMOR_PHYSICS_OVERRIDE);
        this.cfg.setDefault(Configuration.SHOW_IN_ARMOR);
        this.cfg.setDefault(Configuration.BOUNCE_MULTIPLIER);
        this.cfg.setDefault(Configuration.FLOPPY_MULTIPLIER);
        this.cfg.finish();
    }

    @Override
    public void readFromStack(@NotNull class_1799 chestplate) {
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    private <VALUE> boolean updateValue(ConfigKey<VALUE> key, VALUE value, Consumer<VALUE> setter) {
        if (key.validate(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public boolean updateGender(Gender value) {
        return this.updateValue(Configuration.GENDER, value, v -> {
            this.gender = v;
        });
    }

    public boolean updateBustSize(float value) {
        return this.updateValue(Configuration.BUST_SIZE, Float.valueOf(value), v -> {
            this.pBustSize = v.floatValue();
        });
    }

    public boolean hasHurtSounds() {
        return this.hurtSounds;
    }

    public boolean updateHurtSounds(boolean value) {
        return this.updateValue(Configuration.HURT_SOUNDS, value, v -> {
            this.hurtSounds = v;
        });
    }

    public boolean updateBreastPhysics(boolean value) {
        return this.updateValue(Configuration.BREAST_PHYSICS, value, v -> {
            this.breastPhysics = v;
        });
    }

    @Override
    public boolean getArmorPhysicsOverride() {
        return this.armorPhysOverride;
    }

    public boolean updateArmorPhysicsOverride(boolean value) {
        return this.updateValue(Configuration.ARMOR_PHYSICS_OVERRIDE, value, v -> {
            this.armorPhysOverride = v;
        });
    }

    @Override
    public boolean showBreastsInArmor() {
        return this.showBreastsInArmor;
    }

    public boolean updateShowBreastsInArmor(boolean value) {
        return this.updateValue(Configuration.SHOW_IN_ARMOR, value, v -> {
            this.showBreastsInArmor = v;
        });
    }

    public boolean updateBounceMultiplier(float value) {
        return this.updateValue(Configuration.BOUNCE_MULTIPLIER, Float.valueOf(value), v -> {
            this.bounceMultiplier = v.floatValue();
        });
    }

    public boolean updateFloppiness(float value) {
        return this.updateValue(Configuration.FLOPPY_MULTIPLIER, Float.valueOf(value), v -> {
            this.floppyMultiplier = v.floatValue();
        });
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public static JsonObject toJsonObject(PlayerConfig plr) {
        JsonObject obj = new JsonObject();
        Configuration.USERNAME.save(obj, plr.uuid);
        Configuration.GENDER.save(obj, plr.getGender());
        Configuration.BUST_SIZE.save(obj, Float.valueOf(plr.getBustSize()));
        Configuration.HURT_SOUNDS.save(obj, plr.hasHurtSounds());
        Configuration.BREAST_PHYSICS.save(obj, plr.hasBreastPhysics());
        Configuration.SHOW_IN_ARMOR.save(obj, plr.showBreastsInArmor());
        Configuration.ARMOR_PHYSICS_OVERRIDE.save(obj, plr.getArmorPhysicsOverride());
        Configuration.BOUNCE_MULTIPLIER.save(obj, Float.valueOf(plr.getBounceMultiplier()));
        Configuration.FLOPPY_MULTIPLIER.save(obj, Float.valueOf(plr.getFloppiness()));
        Breasts breasts = plr.getBreasts();
        Configuration.BREASTS_OFFSET_X.save(obj, Float.valueOf(breasts.getXOffset()));
        Configuration.BREASTS_OFFSET_Y.save(obj, Float.valueOf(breasts.getYOffset()));
        Configuration.BREASTS_OFFSET_Z.save(obj, Float.valueOf(breasts.getZOffset()));
        Configuration.BREASTS_UNIBOOB.save(obj, breasts.isUniboob());
        Configuration.BREASTS_CLEAVAGE.save(obj, Float.valueOf(breasts.getCleavage()));
        return obj;
    }

    public static PlayerConfig loadCachedPlayer(UUID uuid, boolean markForSync) {
        PlayerConfig plr = WildfireGender.getPlayerById(uuid);
        if (plr != null) {
            plr.syncStatus = SyncStatus.CACHED;
            Configuration config = plr.getConfig();
            plr.updateGender(config.get(Configuration.GENDER));
            plr.updateBustSize(config.get(Configuration.BUST_SIZE).floatValue());
            plr.updateHurtSounds(config.get(Configuration.HURT_SOUNDS));
            plr.updateBreastPhysics(config.get(Configuration.BREAST_PHYSICS));
            plr.updateShowBreastsInArmor(config.get(Configuration.SHOW_IN_ARMOR));
            plr.updateArmorPhysicsOverride(config.get(Configuration.ARMOR_PHYSICS_OVERRIDE));
            plr.updateBounceMultiplier(config.get(Configuration.BOUNCE_MULTIPLIER).floatValue());
            plr.updateFloppiness(config.get(Configuration.FLOPPY_MULTIPLIER).floatValue());
            Breasts breasts = plr.getBreasts();
            breasts.updateXOffset(config.get(Configuration.BREASTS_OFFSET_X).floatValue());
            breasts.updateYOffset(config.get(Configuration.BREASTS_OFFSET_Y).floatValue());
            breasts.updateZOffset(config.get(Configuration.BREASTS_OFFSET_Z).floatValue());
            breasts.updateUniboob(config.get(Configuration.BREASTS_UNIBOOB));
            breasts.updateCleavage(config.get(Configuration.BREASTS_CLEAVAGE).floatValue());
            if (markForSync) {
                plr.needsSync = true;
            }
            return plr;
        }
        return null;
    }

    public static void saveGenderInfo(PlayerConfig plr) {
        Configuration config = plr.getConfig();
        config.set(Configuration.USERNAME, plr.uuid);
        config.set(Configuration.GENDER, plr.getGender());
        config.set(Configuration.BUST_SIZE, Float.valueOf(plr.getBustSize()));
        config.set(Configuration.HURT_SOUNDS, plr.hasHurtSounds());
        config.set(Configuration.BREAST_PHYSICS, plr.hasBreastPhysics());
        config.set(Configuration.SHOW_IN_ARMOR, plr.showBreastsInArmor());
        config.set(Configuration.ARMOR_PHYSICS_OVERRIDE, plr.getArmorPhysicsOverride());
        config.set(Configuration.BOUNCE_MULTIPLIER, Float.valueOf(plr.getBounceMultiplier()));
        config.set(Configuration.FLOPPY_MULTIPLIER, Float.valueOf(plr.getFloppiness()));
        config.set(Configuration.BREASTS_OFFSET_X, Float.valueOf(plr.getBreasts().getXOffset()));
        config.set(Configuration.BREASTS_OFFSET_Y, Float.valueOf(plr.getBreasts().getYOffset()));
        config.set(Configuration.BREASTS_OFFSET_Z, Float.valueOf(plr.getBreasts().getZOffset()));
        config.set(Configuration.BREASTS_UNIBOOB, plr.getBreasts().isUniboob());
        config.set(Configuration.BREASTS_CLEAVAGE, Float.valueOf(plr.getBreasts().getCleavage()));
        config.save();
        plr.needsSync = true;
    }

    @Override
    public boolean hasJacketLayer() {
        throw new UnsupportedOperationException("PlayerConfig does not support #hasJacketLayer(); use PlayerEntity#isPartVisible instead");
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

