/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.physics;

import com.wildfire.api.IGenderArmor;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.entitydata.EntityConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1452;
import net.minecraft.class_1498;
import net.minecraft.class_1531;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4985;
import net.minecraft.class_742;

public class BreastPhysics {
    private float bounceVelX = 0.0f;
    private float targetBounceX = 0.0f;
    private float velocityX = 0.0f;
    private float positionX;
    private float prePositionX;
    private float bounceVel = 0.0f;
    private float targetBounceY = 0.0f;
    private float velocity = 0.0f;
    private float positionY;
    private float prePositionY;
    private float bounceRotVel = 0.0f;
    private float targetRotVel = 0.0f;
    private float rotVelocity = 0.0f;
    private float wfg_bounceRotation;
    private float wfg_preBounceRotation;
    private boolean justSneaking = false;
    private boolean alreadySleeping = false;
    private float breastSize = 0.0f;
    private float preBreastSize = 0.0f;
    private class_243 prePos;
    private final EntityConfig entityConfig;
    private int randomB = 1;
    private boolean alreadyFalling = false;

    public BreastPhysics(EntityConfig entityConfig) {
        this.entityConfig = entityConfig;
    }

    @Environment(value=EnvType.CLIENT)
    public void update(class_1309 entity, IGenderArmor armor) {
        class_243 vec3d2;
        if (entity instanceof class_1531 && !armor.armorStandsCopySettings()) {
            return;
        }
        this.prePositionY = this.positionY;
        this.prePositionX = this.positionX;
        this.wfg_preBounceRotation = this.wfg_bounceRotation;
        this.preBreastSize = this.breastSize;
        if (this.prePos == null) {
            this.prePos = entity.method_19538();
            return;
        }
        float h = 0.0f;
        float i = entity.method_6024(0.0f);
        float bodyXRotation = 0.0f;
        float bodyYRotation = 0.0f;
        if (entity.method_6128()) {
            j = (float)entity.method_6003() + h;
            k = class_3532.method_15363((float)(j * j / 100.0f), (float)0.0f, (float)1.0f);
            if (!entity.method_6123()) {
                bodyXRotation = k * (-90.0f - entity.method_36455());
            }
            if (entity instanceof class_742) {
                class_742 player = (class_742)entity;
                class_243 vec3d = entity.method_5828(h);
                vec3d2 = player.method_49339(h);
                double d = vec3d2.method_37268();
                double e = vec3d.method_37268();
                if (d > 0.0 && e > 0.0) {
                    double l = (vec3d2.field_1352 * vec3d.field_1352 + vec3d2.field_1350 * vec3d.field_1350) / Math.sqrt(d * e);
                    double m = vec3d2.field_1352 * vec3d.field_1350 - vec3d2.field_1350 * vec3d.field_1352;
                    bodyYRotation = (float)(Math.signum(m) * Math.acos(l));
                }
            }
        } else if (i > 0.0f) {
            j = entity.method_5799() ? -90.0f - entity.method_36455() : -90.0f;
            bodyXRotation = k = class_3532.method_16439((float)i, (float)0.0f, (float)j);
        } else if (entity.method_6113()) {
            bodyXRotation = 90.0f;
        } else if (entity.method_18376() == class_4050.field_18081) {
            bodyXRotation = -15.0f;
        }
        float breastWeight = this.entityConfig.getBustSize() * 1.25f;
        float targetBreastSize = this.entityConfig.getBustSize();
        if (!this.entityConfig.getGender().canHaveBreasts()) {
            targetBreastSize = 0.0f;
        } else {
            float tightness = class_3532.method_15363((float)armor.tightness(), (float)0.0f, (float)1.0f);
            if (this.entityConfig.getArmorPhysicsOverride()) {
                tightness = 0.0f;
            }
            targetBreastSize *= 1.0f - 0.15f * tightness;
        }
        this.breastSize += this.breastSize < targetBreastSize ? Math.abs(this.breastSize - targetBreastSize) / 2.0f : -Math.abs(this.breastSize - targetBreastSize) / 2.0f;
        class_243 motion = entity.method_19538().method_1020(this.prePos);
        this.prePos = entity.method_19538();
        float bounceIntensity = targetBreastSize * 3.0f * (float)Math.round(this.entityConfig.getBounceMultiplier() * 3.0f * 100.0f) / 100.0f;
        float resistance = class_3532.method_15363((float)armor.physicsResistance(), (float)0.0f, (float)1.0f);
        if (this.entityConfig.getArmorPhysicsOverride()) {
            resistance = 0.0f;
        }
        bounceIntensity *= 1.0f - resistance;
        if (!this.entityConfig.getBreasts().isUniboob()) {
            bounceIntensity *= WildfireHelper.randFloat(0.5f, 1.5f);
        }
        if (entity.field_6017 > 0.0f && !this.alreadyFalling) {
            this.randomB = entity.method_37908().field_9229.method_43056() ? -1 : 1;
            this.alreadyFalling = true;
        }
        if (entity.field_6017 == 0.0f) {
            this.alreadyFalling = false;
        }
        this.targetBounceY = (float)motion.field_1351 * bounceIntensity;
        this.targetBounceY += breastWeight;
        float horizVel = (float)Math.sqrt(Math.pow(motion.field_1352, 2.0) + Math.pow(motion.field_1350, 2.0)) * bounceIntensity;
        this.targetRotVel = -((entity.field_6283 - entity.field_6220) / 15.0f) * bounceIntensity;
        float f2 = (float)entity.method_18798().method_1027() / 0.2f;
        if ((f2 = f2 * f2 * f2) < 1.0f) {
            f2 = 1.0f;
        }
        this.targetBounceY += class_3532.method_15362((float)(entity.field_42108.method_48569() * 0.6662f + (float)Math.PI)) * 0.5f * entity.field_42108.method_48566() * 0.5f / f2;
        this.targetRotVel += (float)motion.field_1351 * bounceIntensity * (float)this.randomB;
        if (entity.method_18376() == class_4050.field_18081 && !this.justSneaking) {
            this.justSneaking = true;
            this.targetBounceY += bounceIntensity;
        }
        if (entity.method_18376() != class_4050.field_18081 && this.justSneaking) {
            this.justSneaking = false;
            this.targetBounceY += bounceIntensity;
        }
        if (entity.method_5854() != null) {
            class_1297 movement;
            class_1452 pig;
            class_1297 movement22;
            float movement22;
            class_1498 horse;
            class_1297 speed2;
            class_1297 rowTime2;
            vec3d2 = entity.method_5854();
            if (vec3d2 instanceof class_1690) {
                class_1690 boat = (class_1690)vec3d2;
                int rowTime2 = (int)boat.method_7551(0, entity.field_42108.method_48569());
                int rowTime22 = (int)boat.method_7551(1, entity.field_42108.method_48569());
                float rotationL = (float)class_3532.method_15390((double)-1.0471975803375244, (double)-0.2617993950843811, (double)((class_3532.method_15374((float)(-rowTime22)) + 1.0f) / 2.0f));
                float rotationR = (float)class_3532.method_15390((double)-0.7853981852531433, (double)0.7853981852531433, (double)((class_3532.method_15374((float)((float)(-rowTime2) + 1.0f)) + 1.0f) / 2.0f));
                if (rotationL < -1.0f || rotationR < -0.6f) {
                    this.targetBounceY = bounceIntensity / 3.25f;
                }
            }
            if ((rowTime2 = entity.method_5854()) instanceof class_1695) {
                class_1695 cart = (class_1695)rowTime2;
                float speed2 = (float)cart.method_18798().method_1027();
                if (Math.random() * (double)speed2 < 0.5 && speed2 > 0.2f) {
                    this.targetBounceY = (Math.random() > 0.5 ? -bounceIntensity : bounceIntensity) / 6.0f;
                }
            }
            if ((speed2 = entity.method_5854()) instanceof class_1498 && horse.field_6012 % this.clampMovement(movement22 = (float)(horse = (class_1498)speed2).method_18798().method_1027()) == 5 && movement22 > 0.1f) {
                this.targetBounceY = bounceIntensity / 4.0f;
            }
            if ((movement22 = entity.method_5854()) instanceof class_1452 && pig.field_6012 % this.clampMovement(movement = (float)(pig = (class_1452)movement22).method_18798().method_1027()) == 5 && movement > 0.08f) {
                this.targetBounceY = bounceIntensity / 4.0f;
            }
            if ((movement = entity.method_5854()) instanceof class_4985) {
                class_4985 strider = (class_4985)movement;
                double heightOffset = (double)strider.method_17682() - 0.19 + (double)(0.12f * class_3532.method_15362((float)(strider.field_42108.method_48569() * 1.5f)) * 2.0f * Math.min(0.25f, strider.field_42108.method_48566()));
                this.targetBounceY += ((float)(heightOffset * 3.0) - 4.5f) * bounceIntensity;
            }
        }
        if (entity.field_6252 && entity.field_6012 % 5 == 0 && entity.method_18376() != class_4050.field_18078) {
            this.targetBounceY += (Math.random() > 0.5 ? -0.25f : 0.25f) * bounceIntensity;
        }
        if (entity.method_18376() == class_4050.field_18078 && !this.alreadySleeping) {
            this.targetBounceY = bounceIntensity;
            this.alreadySleeping = true;
        }
        if (entity.method_18376() != class_4050.field_18078 && this.alreadySleeping) {
            this.targetBounceY = bounceIntensity;
            this.alreadySleeping = false;
        }
        float percent = this.entityConfig.getFloppiness();
        float bounceAmount = 0.45f * (1.0f - percent) + 0.15f;
        bounceAmount = class_3532.method_15363((float)bounceAmount, (float)0.15f, (float)0.6f);
        float delta = 2.25f - bounceAmount;
        float distanceFromMin = Math.abs(this.bounceVel + 1.5f) * 0.5f;
        float distanceFromMax = Math.abs(this.bounceVel - 2.65f) * 0.5f;
        if (this.bounceVel < -0.5f) {
            this.targetBounceY += distanceFromMin;
        }
        if (this.bounceVel > 2.5f) {
            this.targetBounceY -= distanceFromMax;
        }
        if (this.targetBounceY < -1.5f) {
            this.targetBounceY = -1.5f;
        }
        if (this.targetBounceY > 2.5f) {
            this.targetBounceY = 2.5f;
        }
        if (this.targetRotVel < -25.0f) {
            this.targetRotVel = -25.0f;
        }
        if (this.targetRotVel > 25.0f) {
            this.targetRotVel = 25.0f;
        }
        this.velocity = class_3532.method_16439((float)bounceAmount, (float)this.velocity, (float)((this.targetBounceY - this.bounceVel) * delta));
        this.bounceVel += this.velocity * percent * 1.1625f;
        this.velocityX = class_3532.method_16439((float)bounceAmount, (float)this.velocityX, (float)((this.targetBounceX - this.bounceVelX) * delta));
        this.bounceVelX += this.velocityX * percent;
        this.rotVelocity = class_3532.method_16439((float)bounceAmount, (float)this.rotVelocity, (float)((this.targetRotVel - this.bounceRotVel) * delta));
        this.bounceRotVel += this.rotVelocity * percent;
        this.wfg_bounceRotation = this.bounceRotVel;
        this.positionX = this.bounceVelX;
        this.positionY = this.bounceVel;
        if (this.positionY < -0.5f) {
            this.positionY = -0.5f;
        }
        if (this.positionY > 1.5f) {
            this.positionY = 1.5f;
            this.velocity = 0.0f;
        }
    }

    public float getBreastSize(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.preBreastSize, (float)this.breastSize);
    }

    public float getPrePositionY() {
        return this.prePositionY;
    }

    public float getPositionY() {
        return this.positionY;
    }

    public float getPrePositionX() {
        return this.prePositionX;
    }

    public float getPositionX() {
        return this.positionX;
    }

    public float getBounceRotation() {
        return this.wfg_bounceRotation;
    }

    public float getPreBounceRotation() {
        return this.wfg_preBounceRotation;
    }

    private int clampMovement(float movement) {
        int val = (int)(10.0f - movement * 2.0f);
        if (val < 1) {
            val = 1;
        }
        return val;
    }
}

