/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.wildfire.main.config.ConfigKey;
import java.util.UUID;

public class UUIDConfigKey
extends ConfigKey<UUID> {
    public UUIDConfigKey(String key, UUID defaultValue) {
        super(key, defaultValue);
    }

    @Override
    protected UUID read(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            try {
                return UUID.fromString(primitive.getAsString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (UUID)this.defaultValue;
    }

    @Override
    public void save(JsonObject object, UUID value) {
        object.addProperty(this.key, value.toString());
    }
}

