/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.WildfireGender;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.SyncPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public class WildfireSync {
    public static final class_2960 SEND_GENDER_IDENTIFIER = new class_2960("wildfire_gender", "send_gender_info");
    public static final class_2960 SYNC_IDENTIFIER = new class_2960("wildfire_gender", "sync");

    @Environment(value=EnvType.CLIENT)
    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        SyncPacket packet = new SyncPacket(buf);
        if (client.field_1724 == null || packet.uuid.equals(client.field_1724.method_5667())) {
            return;
        }
        PlayerConfig plr = WildfireGender.getOrAddPlayerById(packet.uuid);
        packet.updatePlayerFromPacket(plr);
        plr.syncStatus = PlayerConfig.SyncStatus.SYNCED;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        SyncPacket packet = new SyncPacket(buf);
        if (player == null || !player.method_5667().equals(packet.uuid)) {
            return;
        }
        PlayerConfig plr = WildfireGender.getOrAddPlayerById(packet.uuid);
        packet.updatePlayerFromPacket(plr);
        WildfireSync.sendToAllClients(player, plr);
    }

    public static void sendToAllClients(class_3222 toSync, PlayerConfig playerConfig) {
        if (playerConfig == null || toSync.method_5682() == null) {
            return;
        }
        SyncPacket syncPacket = new SyncPacket(playerConfig);
        PlayerLookup.tracking((class_1297)toSync).forEach(sendTo -> {
            if (sendTo.method_5667().equals(toSync.method_5667())) {
                return;
            }
            if (ServerPlayNetworking.canSend((class_3222)sendTo, (class_2960)SYNC_IDENTIFIER)) {
                ServerPlayNetworking.send((class_3222)sendTo, (class_2960)SYNC_IDENTIFIER, (class_2540)syncPacket.getPacket());
            }
        });
    }

    public static void sendToClient(class_3222 sendTo, PlayerConfig toSync) {
        if (ServerPlayNetworking.canSend((class_3222)sendTo, (class_2960)SYNC_IDENTIFIER)) {
            class_2540 packet = new SyncPacket(toSync).getPacket();
            ServerPlayNetworking.send((class_3222)sendTo, (class_2960)SYNC_IDENTIFIER, (class_2540)packet);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(PlayerConfig plr) {
        if (plr == null || !plr.needsSync) {
            return;
        }
        class_2540 buffer = new SyncPacket(plr).getPacket();
        ClientPlayNetworking.send((class_2960)SEND_GENDER_IDENTIFIER, (class_2540)buffer);
        plr.needsSync = false;
    }
}

