/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.entitydata;

import com.wildfire.api.IGenderArmor;
import com.wildfire.main.Gender;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.physics.BreastPhysics;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityConfig {
    public static final HashMap<UUID, EntityConfig> ENTITY_CACHE = new HashMap();
    public final UUID uuid;
    protected Gender gender = (Gender)((Object)Configuration.GENDER.getDefault());
    protected float pBustSize = ((Float)Configuration.BUST_SIZE.getDefault()).floatValue();
    protected boolean breastPhysics = (Boolean)Configuration.BREAST_PHYSICS.getDefault();
    protected float bounceMultiplier = ((Float)Configuration.BOUNCE_MULTIPLIER.getDefault()).floatValue();
    protected float floppyMultiplier = ((Float)Configuration.FLOPPY_MULTIPLIER.getDefault()).floatValue();
    protected boolean showBreastsInArmor = (Boolean)Configuration.SHOW_IN_ARMOR.getDefault();
    protected final BreastPhysics lBreastPhysics;
    protected final BreastPhysics rBreastPhysics;
    protected final Breasts breasts;
    protected boolean jacketLayer = true;

    EntityConfig(UUID uuid) {
        this.uuid = uuid;
        this.breasts = new Breasts();
        this.lBreastPhysics = new BreastPhysics(this);
        this.rBreastPhysics = new BreastPhysics(this);
    }

    public void readFromStack(@NotNull class_1799 chestplate) {
        class_2487 nbt;
        class_2487 class_24872 = nbt = !chestplate.method_7960() ? chestplate.method_7941("WildfireGender") : null;
        if (nbt == null) {
            this.gender = Gender.MALE;
            return;
        }
        this.pBustSize = nbt.method_10545("BreastSize") ? nbt.method_10583("BreastSize") : 0.0f;
        Gender gender = this.gender = this.pBustSize > 0.02f ? Gender.FEMALE : Gender.MALE;
        if (nbt.method_10545("Cleavage")) {
            this.breasts.updateCleavage(nbt.method_10583("Cleavage"));
        }
        if (nbt.method_10545("Uniboob")) {
            this.breasts.updateUniboob(nbt.method_10577("Uniboob"));
        }
        if (nbt.method_10545("XOffset")) {
            this.breasts.updateXOffset(nbt.method_10583("XOffset"));
        }
        if (nbt.method_10545("YOffset")) {
            this.breasts.updateYOffset(nbt.method_10583("YOffset"));
        }
        if (nbt.method_10545("ZOffset")) {
            this.breasts.updateZOffset(nbt.method_10583("ZOffset"));
        }
        if (nbt.method_10545("Jacket")) {
            this.jacketLayer = nbt.method_10577("Jacket");
        }
    }

    @Nullable
    public static EntityConfig getEntity(@NotNull class_1309 entity) {
        if (entity instanceof class_1657) {
            return WildfireGender.getPlayerById(entity.method_5667());
        }
        if (entity.method_6109()) {
            return null;
        }
        return ENTITY_CACHE.computeIfAbsent(entity.method_5667(), EntityConfig::new);
    }

    @NotNull
    public Gender getGender() {
        return this.gender;
    }

    @NotNull
    public Breasts getBreasts() {
        return this.breasts;
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public boolean hasBreastPhysics() {
        return this.breastPhysics;
    }

    public boolean getArmorPhysicsOverride() {
        return false;
    }

    public boolean showBreastsInArmor() {
        return true;
    }

    public float getBounceMultiplier() {
        return this.bounceMultiplier;
    }

    public float getFloppiness() {
        return this.floppyMultiplier;
    }

    @NotNull
    public BreastPhysics getLeftBreastPhysics() {
        return this.lBreastPhysics;
    }

    @NotNull
    public BreastPhysics getRightBreastPhysics() {
        return this.rBreastPhysics;
    }

    public boolean hasJacketLayer() {
        return this.jacketLayer;
    }

    @Environment(value=EnvType.CLIENT)
    public void tickBreastPhysics(@NotNull class_1309 entity) {
        IGenderArmor armor = WildfireHelper.getArmorConfig(entity.method_6118(class_1304.field_6174));
        this.getLeftBreastPhysics().update(entity, armor);
        this.getRightBreastPhysics().update(entity, armor);
    }

    public String toString() {
        return "%s(uuid=%s, gender=%s)".formatted(new Object[]{this.getClass().getCanonicalName(), this.uuid, this.gender});
    }
}

